\name{PCombine}
\alias{PCombine}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Combine multiple SNPs for one gene
}
\description{
Compute a summarizing P value for each gene from multiple SNPs related to the gene in a GWAS dataset. 
}
\usage{
PCombine(gene.map, method = "NULL")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{gene.map}{
a data.frame containing Gene-SNP-P information such as one returned by "SNP2Gene.match"
}
  \item{method}{
one of "simes", "smallest", "fisher", "gwbon"
}
}
\details{
To generate a summarized P value for each gene based on multiple SNPs represented in a GWAS dataset, several methods are implemented by PCombine:
simes (the Simes method), fisher (Fisher's combined method), smallest (using the smallest P value for the gene), or gwbon (using the smallest P value for the gene after gene-wise Bonferroni correction).

}
\value{
%%  ~Describe the value returned
  \item{gene2weight }{an object of data.frame, including gene and its summarized P value}
}
\references{
Luo L, Peng G, Zhu Y, Dong H, Amos CI, Xiong M. (2010). Genome-wide gene and pathway analysis. Eur J Hum Genet, Epub ahead of print
}
\examples{
#gene2weight = PCombine(gene.map, method="smallest")
}

