\name{dms}
\Rdversion{1.1}
\alias{dms}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Dense module searching function
}
\description{
dms constructs a node-weighted PPI network, performs dense module searching, generates simulation data from random networks, normalizes module scores using simulation data, removes un-qualified modules, and orders resultant modules according to their significance.  
}
\usage{
dms(network, gene2weight, d=2, r=0.1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{network}{
A data frame containing a symbolic edge list of the PPI network.
}
  \item{gene2weight}{
A data frame containing two columns: the first is unique gene identifier (should be coordinate with the node symbol used in pina); the second is P values from GWAS.
this can also be generated from SNP2Gene.match.R
}
  \item{d}{
An integer used to define neighborhood genes to perform searching. Default is 2.
}
  \item{r}{
A float indicating the cutoff for increasement during module expanding process. Greater r will generate smaller module. Default is 0.1.
}

}

\value{
A list containing all important data including the node-weighted network used for searching, resultant dense module list, module score matrix containing Zm and Zn, and randomization data for normalization.
A file named "RESULT.list.RData" is also automatically saved in the working folder for future record.
}
\references{
Jia P, Zheng S, Sun J, Long J, Zheng W, and Zhao Z. (2010). Discovering combined causal signals from genome-wide association studies (GWAS) by network module based approach.
}
\examples{
#res.list = dms(network, gene2weight, d=2, r=0.1)
}
