\name{zn.permutation}
\Rdversion{1.1}
\alias{zn.permutation}
\docType{data}
\title{
Analysis of permutation data to compute nominal P value for each module
}
\description{
This function will compute Zn for each module in the permutation data and count the number of permutations that have higher Zn than the real case for each module. A nominal P is computed then to indicate the association of each module with the disease of interest.
}
\usage{
zn.permutation(module.list, gene2snp, gene2snp.method='smallest', original.file, permutation.dir)
}
\arguments{
  \item{module.list}{
a list of modules to test using permutation data.
}
  \item{gene2snp}{
a dataframe describing the gene ~ snp relationship coming in two columnds, gene and snp.
}
  \item{gene2snp.method}{
one of "simes", "smallest", "fisher", "gwbon". must be the same as used in PCombine.
}
	\item{original.file}{
path to the assoc file of the real data. 
}
	\item{permutation.dir}{
path to the folder where permutation data files (generated by PLINK) are located.
}

}
\format{
  The format is:
 chr "zn.permutation.R"
}
\details{
This function will compute Zn for each module in the permutation data and count the number of permutations that have higher Zn than the real case for each module. A nominal P is computed to indicate the association of each module with the disease of interest.
}
\value{
zn.matrix: matrix, each row for one module and each column for one permutation data. Zn(ij) in the matrix indicates Zn of ith module in jth permutation (j=1:1000). The last column is the Zn for real case of modules. 
}
\references{
Jia P, Zheng S, Sun J, Long J, Zheng W, and Zhao Z. (2010). Discovering combined causal signals from genome-wide association studies (GWAS) by network module based approach.
}
\examples{
#zn.permutation(module.list, gene2snp, perm.split.dir)
}
