PCombine <-
function(gene.map, method='NULL')
{
	#gene.map: gene, SNP, P
	if(!is.element(method, c('simes', 'smallest', 'fisher', 'gwbon')) | method=='NULL')
	{
		stop('please choose a method: smallest, simes, fisher, gwbon (gene-wise bonferroni)')
	}
	
	tapply(gene.map$P, gene.map$Gene, c) -> t
	idx = lapply(t, function(x){return(length(x)==0)})
	t.clean = t[!unlist(idx)]
	
	if(method=='simes')
	{
		t2 = lapply(t.clean, function(x){tmp=sort(x); pos=seq(1:length(tmp)); tmp2=tmp*length(tmp)/pos; return(min(tmp2))})
		gene2weight = data.frame(gene=names(t2), weight=unlist(t2))
	}
	if(method=='smallest')
	{
		tapply(gene.map$P, gene.map$Gene, min) -> gene2weight
		data.frame(gene=names(gene2weight), weight=gene2weight) -> gene2weight
		gene2weight = gene2weight[!is.na(gene2weight[,2]), ]
	}
	if(method=='fisher')
	{
		tapply(gene.map$P, gene.map$Gene, function(x){sum(-2*log(x))->chi2; p=1-pchisq(chi2, 2*length(x)); return(p);}) -> gene2weight
		data.frame(gene=names(gene2weight), weight=gene2weight) -> gene2weight
		gene2weight = gene2weight[!is.na(gene2weight[,2]), ]
	}
	if(method=='gwbon')
	{
		tapply(gene.map$P, gene.map$Gene, function(x){tmp2 = p.adjust(x, method='bonferroni'); return(min(tmp2));}) -> gene2weight
		data.frame(gene=names(gene2weight), weight=gene2weight) -> gene2weight
		gene2weight = gene2weight[!is.na(gene2weight[,2]), ]
	}
	return(gene2weight)
}

