dualEval <-
function(resfile1, resfile2)
{
	load(resfile1)
	dis.list <- res.list
	rm(res.list)
	load(resfile2)
	eval.list <- res.list
	rm(res.list)
	
	dis.genesets <- dis.list$genesets.clear
	dis.length.null.dis <- dis.list$genesets.length.null.dis
	dis.length.null.stat <- dis.list$genesets.length.null.stat
	eval.length.null.dis <- eval.list$genesets.length.null.dis
	eval.length.null.stat <- eval.list$genesets.length.null.stat
	zi.by.dis <- data.frame(gene=names(dis.genesets), zi.dis=-9, za.dis=-9, nominalP.dis=-9, zi.eval=-9, za.eval=-9, nominalP.eval=-9)
	for(k in 1:length(dis.genesets))
	{
		genes <- dis.genesets[[k]]
		match(genes, dis.list$graph.g.weight[,1]) -> idx
		idx <- idx[!is.na(idx)]
		if(length(idx)!=0){zi.by.dis[k,2] <- sum(dis.list$graph.g.weight[idx, 2])/sqrt(length(idx))}
		tmp <- dis.length.null.stat[[as.character(length(idx))]]
		l.zperm <- dis.length.null.dis[[as.character(length(idx))]]
		zi.by.dis[k,3] = (zi.by.dis[k,2]-tmp[1])/tmp[2]
		zi.by.dis[k,4]=sum(l.zperm>=zi.by.dis[k,2])/length(l.zperm)
		
		#check the weight of these genes in evaluation dataset
		match(genes, eval.list$graph.g.weight[,1]) -> idx
		idx <- idx[!is.na(idx)]
		if(length(idx)!=0){zi.by.dis[k,5] <- sum(eval.list$graph.g.weight[idx, 2])/sqrt(length(idx))}
		
		if(!is.element(length(idx), names(eval.length.null.stat)))
		{
			print(k)
			print(dis.genesets[k])
			next()
		}
		tmp <- eval.length.null.stat[[as.character(length(idx))]]
		l.zperm <- eval.length.null.dis[[as.character(length(idx))]]
		zi.by.dis[k,6] = (zi.by.dis[k,5]-tmp[1])/tmp[2]
		zi.by.dis[k,7]=sum(l.zperm>=zi.by.dis[k,5])/length(l.zperm)
		#cat(k, '.', sep='')
	}
	zod = zi.by.dis[order(zi.by.dis[,3], decreasing=T), ]
	zod.sig = zod[zod[,3]>quantile(zod[,3], probs=.95)&zod[,6]>quantile(zod[,6], probs=.95),]
	zod.res = list(zod=zod, zod.sig=zod.sig)
	return(zod.res)
}

