moduleChoose <-
function(seed.nodes, res.list, plot=FALSE)
{
	if (!require(igraph)) {
		stop('igraph must be pre-installed!\n')
	}	
	match(seed.nodes, names(res.list$genesets.clear)) -> idx
	module.nodes = unique(unlist(res.list$genesets.clear[idx]))
	subG = induced.subgraph(res.list$GWPI, module.nodes)
	results = list(modules=res.list$genesets.clear[idx], subnetwork=subG)
	if(plot)
	{
		x = V(subG)$weight
		nx = (x-min(x))/(max(x)-min(x))
		tkplot(subG, vertex.label=V(subG)$name, vertex.size=5, vertex.color=gray(nx), vertex.label.dist=1, layout=layout.fruchterman.reingold)
	}
	#return(list(subnetwork = subG, module.list = results))
	return(results)
}

