simpleChoose <-
function(res.list, top=100, plot=FALSE)
{
	if (!require(igraph)) {
		stop('igraph must be pre-installed!\n')
	}	
	match(res.list$zi.ordered[1:top,1], names(res.list$genesets.clear)) -> mod.idx
	genes=unique(unlist(res.list$genesets.clear[mod.idx]))
	subG <- induced.subgraph(res.list$GWPI, genes)
	results = list(modules=res.list$genesets.clear[mod.idx], subnetwork=subG)
	x = V(subG)$weight
	nx = (x-min(x))/(max(x)-min(x))
	if(plot)tkplot(subG, vertex.label=V(subG)$name, vertex.size=5, vertex.color=gray(nx), vertex.label.dist=1, layout=layout.fruchterman.reingold)
	return(results)
}

