statResults <-
function(res.list, top=500)
{
	if (!require(igraph)) {
		stop('igraph must be pre-installed!\n')
	}	
	sets.length <- c()
	sets.cc <- c()
	sets.as <- c()
	sets.ad <- c()
	genes <- c()
	genesets.name = names(res.list$genesets.clear)
	k=1
	while(TRUE)
	{
		match(res.list$zi.ordered[k,1], genesets.name) -> idx
		genes <- c(genes, res.list$genesets.clear[[idx]])
		genes <- unique(genes)
		sets.length <- rbind(sets.length, length(genes));
		#match(genes, V(res.list$GWPI)$name)-1 -> tmp
		induced.subgraph(res.list$GWPI, genes) -> sub.tmp
		sets.cc <- c(sets.cc, transitivity(sub.tmp))
		sets.as <- c(sets.as, average.path.length(sub.tmp))
		deg <- degree(sub.tmp)
		sets.ad <- c(sets.ad, mean(deg))
		k = k+1
		if(k==top)break();
	}
	par(mfrow=c(2,2))
	plot(sets.length, main='No. of genes in total', xlab='Index of modules', ylab='No.of genes')
	plot(sets.cc, main='Clustering coefficient', xlab='Index of modules', ylab='Clustering coefficient')
	plot(sets.as, main='Average shortest path', xlab='Index of modules', ylab='Average shortest path')
	plot(sets.ad, main='Average degree', xlab='Index of modules', ylab='Average degree')	
}

