zn.permutation <- function(module.list, gene2snp, gene2snp.method="smallest", original.file, permutation.dir)
{
	tmp <- read.table(file=original.file, header=T)
	header = names(tmp)
	if((!is.element("SNP", header)) || (!is.element("P", header)))
	{
		stop("please make sure the head line of original.file contains SNP and P...")
	}
	snp2p <- data.frame(tmp$SNP, tmp$P)
	cat("SNPs in total: ", length(snp2p[,1]), sep="")
	
	match(gene2snp[,2], snp2p[,1]) -> x1;
	x2 <- x1[!is.na(x1)]
	gene2snp2p <- data.frame(Gene=gene2snp[!is.na(x1),1], SNP=gene2snp[!is.na(x1),2], P=snp2p[x2,2]); #only SNPs covered by genes
	print(paste("SNPs covered by genes: ", length(gene2snp2p[,1]), sep=""))
	
	gene2weight = PCombine(gene2snp2p, method=gene2snp.method)
	
	perm.files = dir(permutation.dir)
	
	zn.matrix = matrix(-9, ncol=length(perm.files)+1, nrow=length(module.list))
	rownames(zn.matrix)=names(module.list)
	
	
	for(k in 1:length(module.list))
	{
		genes = module.list[[k]]
		match(genes, gene2weight[,1]) -> idx
		idx = idx[!is.na(idx)]
		zn.matrix[k, length(perm.files)+1]=sum(qnorm(1-as.numeric(gene2weight[idx, 2])))/sqrt(length(idx))
	}
	
	for(l in 1:length(perm.files))
	{
		tmp <- read.table(file=paste(permutation.dir, perm.files[l], sep="/"), header=T)
		header = names(tmp)
		if((!is.element("SNP", header)) || (!is.element("P", header)))
		{
			stop(paste("please make sure the head line contains SNP and P in the file ", permutation.dir, "/", perm.files[l], sep=""))
		}
		snp2p <- data.frame(tmp$SNP, tmp$P)
		
		match(gene2snp[,2], snp2p[,1]) -> x1;
		x2 <- x1[!is.na(x1)]
		gene2snp2p <- data.frame(Gene=gene2snp[!is.na(x1),1], SNP=gene2snp[!is.na(x1),2], P=snp2p[x2,2]); #only SNPs covered by genes
	
		gene2weight = PCombine(gene2snp2p, method=gene2snp.method)
		
		for(k in 1:length(module.list))
		{
			genes = module.list[[k]]
			match(genes, gene2weight[,1]) -> idx
			idx = idx[!is.na(idx)]
			zn.matrix[k, l]=sum(qnorm(1-as.numeric(gene2weight[idx, 2])))/sqrt(length(idx))
		}
		cat(l, ".", sep="")
	}
	
	zn.nominal = matrix(-9, ncol=3, nrow=length(module.list))
	colnames(zn.nominal)=c("Seed", "Zm", "EmpiricalP")
	for(k in 1:length(module.list))
	{
		zn.nominal[k,1] = as.character(names(module.list[k]))
		zn.nominal[k,2] = zn.matrix[k, length(perm.files)+1];
		tmp = zn.matrix[k, 1:length(perm.files)];
		zn.nominal[k,3] = sum(tmp>as.numeric(zn.nominal[k,2]))/length(perm.files)
	}
	zn.nominal=as.data.frame(zn.nominal)
	
	return(list(Zn.EmpiricalP=zn.nominal, Zn.Permutation=zn.matrix))
}