/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class glad {
    public static void main(String[] args) {
        try {
            String pathToPLINK = "";
            String gene = "";
            String geneCoord = "";
            String effectiveRegions = "";
            String assocFile = "";
            int i = 0;
            while (i < args.length) {
                String[] line = args[i].split("=");
                if (line[0].equals("pathToPLINK")) {
                    pathToPLINK = line[1];
                }
                if (line[0].equals("gene")) {
                    gene = line[1];
                }
                if (line[0].equals("geneCoord")) {
                    geneCoord = line[1];
                }
                if (line[0].equals("effectiveRegions")) {
                    effectiveRegions = line[1];
                }
                if (line[0].equals("assocFile")) {
                    assocFile = line[1];
                }
                ++i;
            }
            if (pathToPLINK == "" || gene == "" || geneCoord == "" || effectiveRegions == "" || assocFile == "") {
                System.out.println("usage: java resampleEvaluation gene=<geneSymbolOfInterest> geneCoord=<human gene coordinate file, e.g., glist-hg18.txt> effectiveRegions=<effectiveRegions> assocFile=<.assoc> pathToPLINK=</path/to/plink>");
            } else {
                glad.wrapper(gene, geneCoord, effectiveRegions, assocFile, pathToPLINK);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void wrapper(String gene, String geneCoord, String effectiveRegions, String assocFile, String pathToPLINK) throws Exception {
        String str;
        BufferedReader bin = new BufferedReader(new FileReader(new File(geneCoord)));
        while ((str = bin.readLine()) != null) {
            String[] line = str.split(" ");
            if (!gene.equals(line[3])) continue;
            int start = Integer.parseInt(line[1]);
            int end = Integer.parseInt(line[2]);
            glad.randomNumber(line[3], line[0], start, end, effectiveRegions, assocFile, pathToPLINK);
        }
        bin.close();
    }

    public static void randomNumber(String gene, String gene_chr, int start, int end, String effectiveRegions, String assocFile, String pathToPLINK) throws Exception {
        String tmpbuf;
        String str;
        Vector<String> vec = new Vector<String>();
        int genelength = Math.abs(end - start);
        BufferedReader bin = new BufferedReader(new FileReader(new File(effectiveRegions)));
        while ((str = bin.readLine()) != null) {
            vec.add(str);
        }
        bin.close();
        int[][] mat = new int[vec.size()][2];
        String[] chr = new String[vec.size()];
        int i = 0;
        while (i < vec.size()) {
            str = (String)vec.get(i);
            String[] line = str.split("\t");
            chr[i] = line[0];
            mat[i][0] = Integer.parseInt(line[1]);
            mat[i][1] = Integer.parseInt(line[2]);
            ++i;
        }
        BufferedWriter bout = new BufferedWriter(new FileWriter(new File("tmp.random.intervals")));
        bout.write(String.valueOf(gene_chr) + " " + start + " " + end + " real\n");
        int i2 = 0;
        while (i2 < 1000) {
            int max;
            int x = new Random().nextInt(vec.size() - 1);
            int min = mat[x][0] + genelength / 2;
            if (min <= (max = mat[x][1] - genelength / 2)) {
                int y = min + new Random().nextInt(max - min);
                bout.write(String.valueOf(chr[x]) + " " + (y - genelength) + " " + (y + genelength) + " ran" + i2 + "\n");
            }
            ++i2;
        }
        bout.flush();
        bout.close();
        System.out.println("random interval generated");
        String plinkCmd = String.valueOf(pathToPLINK) + " --gene-report " + assocFile + " --gene-list tmp.random.intervals --gene-list-border 20 --out randomTmp";
        Runtime r = Runtime.getRuntime();
        System.out.println("executing PLINK to map SNPs to intervals...");
        Process cmdProc = r.exec(plinkCmd);
        BufferedReader tmpbr = new BufferedReader(new InputStreamReader(cmdProc.getInputStream()));
        while ((tmpbuf = tmpbr.readLine()) != null) {
        }
        cmdProc.waitFor();
        tmpbr.close();
        String tabF = "randomTmp_" + gene + ".prr.tab";
        String minpF = "randomTmp_" + gene + ".prr.minp.tab";
        glad.countResult("randomTmp.range.report", tabF);
        glad.minPanno(tabF, minpF);
        String Rcmd = "R --vanilla --slave --args prr.minp.tab=" + minpF + " output.pdf=" + gene + ".pdf < Rwrapper.R";
        System.out.println("drawing in R...");
        r = Runtime.getRuntime();
        cmdProc = r.exec(Rcmd);
        tmpbr = new BufferedReader(new InputStreamReader(cmdProc.getInputStream()));
        while ((tmpbuf = tmpbr.readLine()) != null) {
            System.out.println(tmpbuf);
        }
        cmdProc.waitFor();
        tmpbr.close();
        File x = new File(tabF);
        if (x.exists()) {
            x.delete();
        }
        if ((x = new File("randomTmp.range.report")).exists()) {
            x.delete();
        }
        if ((x = new File("randomTmp.log")).exists()) {
            x.delete();
        }
        if ((x = new File(".pversion")).exists()) {
            x.delete();
        }
    }

    public static void countResult(String reportF, String tabF) throws Exception {
        String str;
        BufferedReader bin = new BufferedReader(new FileReader(new File(reportF)));
        BufferedWriter bout = new BufferedWriter(new FileWriter(new File(tabF)));
        Hashtable ht = new Hashtable();
        int distIndex = 0;
        int chrIndex = 0;
        int posIndex = 0;
        int PIndex = 0;
        int SNPIndex = 0;
        block0: while ((str = bin.readLine()) != null) {
            if (str.indexOf("--") == -1) continue;
            String gene = str.substring(0, str.indexOf(" "));
            String tmp = bin.readLine();
            distIndex = 0;
            chrIndex = 0;
            posIndex = 0;
            PIndex = 0;
            SNPIndex = 0;
            while ((tmp = bin.readLine()) != null) {
                if (tmp.trim().length() < 1) continue block0;
                String[] line = tmp.split("\\s{1,}");
                if (tmp.indexOf("DIST") != -1) {
                    int k = 0;
                    while (k < line.length) {
                        if (line[k].equals("DIST")) {
                            distIndex = k;
                        }
                        if (line[k].equals("CHR")) {
                            chrIndex = k;
                        }
                        if (line[k].equals("BP")) {
                            posIndex = k;
                        }
                        if (line[k].equals("P")) {
                            PIndex = k;
                        }
                        if (line[k].equals("SNP")) {
                            SNPIndex = k;
                        }
                        ++k;
                    }
                    continue;
                }
                bout.write(String.valueOf(gene) + "\t" + line[SNPIndex] + "\t" + line[chrIndex] + "\t" + line[posIndex] + "\t" + line[PIndex] + "\t" + line[distIndex] + "\n");
            }
        }
        if (distIndex == 0 && chrIndex == 0 && posIndex == 0 && PIndex == 0 && SNPIndex == 0) {
            System.out.println("Warning: Please check if the following columns exist: DIST, CHR, BP, P, SNP");
        }
        bin.close();
        bout.flush();
        bout.close();
    }

    public static void minPanno(String tabF, String minpF) throws Exception {
        String str;
        BufferedReader bin = new BufferedReader(new FileReader(new File(tabF)));
        Hashtable<String, Vector> ht = new Hashtable<String, Vector>();
        while ((str = bin.readLine()) != null) {
            Vector vec;
            String[] line = str.split("\t");
            if (ht.containsKey(line[0])) {
                vec = (Vector)ht.get(line[0]);
                vec.add(line);
                continue;
            }
            vec = new Vector();
            vec.add(line);
            ht.put(line[0], vec);
        }
        bin.close();
        System.out.println("Effective number of intervals: " + ht.size());
        BufferedWriter bout = new BufferedWriter(new FileWriter(new File(minpF)));
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            String gene = (String)en.nextElement();
            Vector vec = (Vector)ht.get(gene);
            int index = 0;
            double minp = 1.0;
            int i = 0;
            while (i < vec.size()) {
                String[] line = (String[])vec.get(i);
                double min_tmp = Double.parseDouble(line[4]);
                if (min_tmp != -1.0 && min_tmp < minp) {
                    minp = min_tmp;
                    index = i;
                }
                ++i;
            }
            String[] line = (String[])vec.get(index);
            bout.write(line[0]);
            int k = 1;
            while (k < line.length) {
                bout.write("\t" + line[k]);
                ++k;
            }
            bout.write("\n");
        }
        bout.flush();
        bout.close();
    }
}

